/*
Author       : Shadat.
Template Name: Duxer - Industrial Constriction Business Html5 Template
Version      : 1.0
*/
/*=============================================
TABLE OF CONTENTS
================================================

1. PRELOADER JS
2. JQUERY STICKY MENU
3. SCROLL MENU JS
4. SECTIONS BACKGROUNDS
5. ACTIVE BOOTSTRAP TOOLTIP
6. MOBILE MENU JS
7. HOME SLIDER JS
8. TEAM SLIDER JS
9. TESTIMONIAL SLIDER JS
10. CLIENT SLIDER JS
11. COUNTDOWN JS
12. VENOBOX JS
13. PORTFOLIO JS
14. HOME ACCORDION JS
15. FAQ ACCORDION JS
16. SLICK SLIDER JS
17. WOW ANIMATION JS

Table Of Contents end
================================================
*/

(function($) {
    'use strict';

    $(document).ready(function(){


        /* 1. PRELOADER JS */

            function fadeOut(el) {
                el.style.opacity = 0.4;
                var last;
                var tick = function() {
                    el.style.opacity = +el.style.opacity - (new Date() - last) / 600;
                    last = +new Date();
                    if (+el.style.opacity > 0) {
                        (window.requestAnimationFrame && requestAnimationFrame(tick)) || setTimeout(tick, 100);
                    } else {
                        el.style.display = "none";
                    }
                };
                tick();
            }
            var pagePreloaderId = document.getElementById("page-preloader");
            setTimeout(function() {
                fadeOut(pagePreloaderId)
            }, 1000);
     

            /* 2. JQUERY STICKY MENU */

            $(".sticky-menu").sticky({
                topSpacing: 0
            });


            /* 3. SCROLL MENU JS */

            $(window).on('scroll', function () {
                if ($(this).scrollTop() > 200) {
                    $('.mainmenu-area').addClass('menu-animation');
                    $('.topcontrol').addClass('topanimation');
                } else {
                    $('.mainmenu-area').removeClass('menu-animation');
                    $('.topcontrol').removeClass('topanimation');
                }
            });


            /* 4. SECTIONS BACKGROUNDS */

            var pageSection = $("section,div");
            pageSection.each(function(indx) {

                if ($(this).attr("data-background")) {
                    $(this).css("background-image", "url(" + $(this).data("background") + ")");
                }
            });
        

            /* 5. ACTIVE BOOTSTRAP TOOLTIP */

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })


            /* 6. MOBILE MENU JS */

            $(".mobile-topbar .bars i").on("click", function () {
                $(".mobile-menu-overlay,.mobile-menu-main").addClass("active");
                return false;
            });

            $(".close-mobile-menu,.mobile-menu-overlay").on("click", function () {
                $(".mobile-menu-overlay,.mobile-menu-main").removeClass("active");
            });

            $('.sub-mobile-menu ul').hide();
            $(".sub-mobile-menu a").on("click", function () {
                $(this).parent(".sub-mobile-menu").children("ul").slideToggle("100");
                $(this).find(".right").toggleClass("fa-caret-up fa-caret-down");
            });


            /* 6. HOME SLIDER JS */

            $('.home-slides').owlCarousel({
                loop: true,
                autoplay: false,
                autoplayTimeout: 4000,
                dots: true,
                items: 1,
                nav: true,
                navText: ["<i class='icofont icofont-arrow-left'></i>", "<i class='icofont icofont-arrow-right'></i>"],
                responsiveClass:true,
                responsive:{
                    0:{
                        items:1,
                        nav:false
                    },
                    600:{
                        items:1,
                        nav:false
                    },
                    768:{
                        items:1,
                        nav:true
                    },
                    1000:{
                        items:1,
                        nav:true
                    }
                }
            });


            /* 7. TEAM SLIDER JS */

            $('.team-slider').owlCarousel({
                loop: true,
                margin: 30,
                autoplay: false,
                autoplayTimeout: 4000,
                navSpeed: 700,
                dotsSpeed: 700,
                dragEndSpeed: 1000,
                dots: true,
                responsiveClass:true,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    768:{
                        items:2
                    },
                    1000:{
                        items:3
                    }
                }
            });

                
            /* 8. TESTIMONIAL SLIDER JS */

            $('#testimonial-slider').owlCarousel({
                loop: true,
                margin: 30,
                autoplay: false,
                autoplayTimeout: 4000,
                navSpeed: 700,
                dotsSpeed: 700,
                dragEndSpeed: 1000,
                dots: true,
                responsiveClass:true,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    768:{
                        items:1
                    },
                    1000:{
                        items:2
                    }
                }
            });

            $('#testimonial-slider-about').owlCarousel({
                loop: true,
                margin: 30,
                autoplay: false,
                autoplayTimeout: 4000,
                navSpeed: 700,
                dotsSpeed: 700,
                dragEndSpeed: 1000,
                dots: true,
                responsiveClass:true,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    768:{
                        items:1
                    },
                    1000:{
                        items:1
                    }
                }
            });

            /* 9. CLIENT SLIDER JS */

            $('.client-slider').owlCarousel({
                margin: 30,
                loop: true,
                autoplay: true,
                autoplayTimeout: 4000,
                dragEndSpeed: 700,
                dots: false,
                nav: false,
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 2
                    },
                    768: {
                        items: 3
                    },
                    1000: {
                        items: 5
                    }
                }
            });


            /* 10. COUNTDOWN JS */

            $('.counter-section').on('inview', function(event, visible, visiblePartX, visiblePartY) {
                if (visible) {
                    $(this).find('.timer').each(function() {
                        var $this = $(this);
                        $({
                            Counter: 0
                        }).animate({
                            Counter: $this.text()
                        }, {
                            duration: 2000,
                            easing: 'swing',
                            step: function() {
                                $this.text(Math.ceil(this.Counter));
                            }
                        });
                    });
                    $(this).unbind('inview');
                }
            });
            /* END COUNTDOWN JS */


            /* 11. VENOBOX JS */

            $('.venobox').venobox({
                numeratio: true,
                titleattr: 'data-title',
                spinner: 'cube-grid',
                spinColor: '#fff'
            });


            /* 12. PORTFOLIO JS */

            $(".portfolio-filter-menu ul li").click(function () {
                $(".portfolio-filter-menu ul li").removeClass("active");
                $(this).addClass("active");
                var selector = $(this).attr("data-filter");
                $(".project-list").isotope({
                    filter: selector,
                });
            });

            $(".project-list").isotope();


            /* 13. HOME ACCORDION JS */

            $(".accordion-box").on('click', '.acc-btn', function () {
                var outerBox = $(this).parents('.accordion-box');
                var target = $(this).parents('.accordion');
                if ($(this).hasClass('active') !== true) {
                    $('.accordion .acc-btn').removeClass('active');
                }
                if ($(this).next('.acc-content').is(':visible')) {
                    return false;
                } else {
                    $(this).addClass('active');
                    $(outerBox).children('.accordion').removeClass('active-block');
                    $(outerBox).find('.accordion').children('.acc-content').slideUp(300);
                    target.addClass('active-block');
                    $(this).next('.acc-content').slideDown(300);
                }
            });


            /* 14. FAQ ACCORDION JS  */

            var selectIds = $('#collapse1,#collapse2,#collapse3,#collapse4,#collapse5');
            $(function($) {
                selectIds.on('show.bs.collapse hidden.bs.collapse', function() {
                    $(this).prev().find('.icofont').toggleClass('icofont-minus icofont-plus');
                })
            });


            /* 15. SLICK SLIDER JS  */
    
            // The slider being synced must be initialized first
            $('#carousel').flexslider({
                animation: "slide",
                controlNav: false,
                animationLoop: false,
                slideshow: false,
                itemWidth: 177,
                itemMargin: 28,
                asNavFor: '#slider',
                controlsContainer: $("#carousel"),
                customDirectionNav: $(".custom-navigation a")
            });

            $('#slider').flexslider({
                animation: "slide",
                controlNav: false,
                animationLoop: false,
                slideshow: false,
                sync: "#carousel",
                directionNav: false,
            });





            /* 16. CURSOR POINTER JS  */

            init_pointer({
              pointerColor: "#F4BC16",
              ringSize: 5,
              ringClickSize: 4
            });







});


        /* 17. WOW ANIMATION JS */

        new WOW().init();

        
			
})(jQuery);